#include <stdio.h>
#include <stdint.h>
char* payload  = "\x46\xc0\x00\x20\xe3\xf1\x00\x00\x01\x02\x67\x7a\xc0\xa8\x38\x02" \
"\xe0\x00\x00\x01\x94\x04\x00\x00\x11\x64\x00\x00\x00\x00\x00\x00";

uint16_t inetChksum(uint16_t *addr, int len) {
    register int nleft = len;
    register uint16_t *w = addr;
    uint16_t answer = 0;
    register int32_t sum = 0;

    /*
     *  Our algorithm is simple, using a 32 bit accumulator (sum),
     *  we add sequential 16 bit words to it, and at the end, fold
     *  back all the carry bits from the top 16 bits into the lower
     *  16 bits.
     */
    while (nleft > 1) {
        sum += *w++;
        nleft -= 2;
    }

    /* mop up an odd byte, if necessary */
    if (nleft == 1) {
        *(uint8_t *) (&answer) = *(uint8_t *)w ;
        sum += answer;
    }

    /*
     * add back carry outs from top 16 bits to low 16 bits
     */
    sum = (sum >> 16) + (sum & 0xffff); /* add hi 16 to low 16 */
    sum += (sum >> 16);                 /* add carry */
    answer = ~sum;                      /* truncate to 16 bits */
    return(answer);
}

int main() {
    uint16_t ck = inetChksum(payload, 32);
    printf("check sum is %#04x\n", ck);
    return 0;
}