<?php
/*
	ladvd.inc
        Copyright (C) 2006 Scott Ullrich
	All rights reserved.

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.

	2. Redistributions in binary form must reproduce the above copyright
	   notice, this list of conditions and the following disclaimer in the
	   documentation and/or other materials provided with the distribution.

	THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
	AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	POSSIBILITY OF SUCH DAMAGE.
*/

require_once("util.inc");
require_once("functions.inc");
require_once("pkg-utils.inc");
require_once("globals.inc");

function ladvd_install_command() {
	conf_mount_rw();
	exec("pkg_add http://ftp.freebsd.org/pub/FreeBSD/ports/i386/packages-8.3-release/net/ladvd-1.0.2.tbz");
	conf_mount_ro();
}

function ladvd_deinstall_command() {
	conf_mount_rw();
	exec("pkg_delete -f ladvd-1.0.2");
	conf_mount_ro();
}

function ladvd_resync_config() {
	global $config;

	conf_mount_rw();
	unlink_if_exists("/etc/rc.d/ladvd");

	$ladvd_conf = &$config['installedpackages']['ladvd']['config'][0];

	/* ladvd is turned off in package settings */
	if($ladvd_conf['enable'] == "0") {
		return;
	}

	$cmdline = "";

	if($ladvd_conf['autoenable'] != "") {
	    $cmdline .= "-a ";
	}

	if($ladvd_conf['silent'] != "") {
	    $cmdline .= "-s ";
	}

	if($ladvd_conf['management'] != "") {
	    $cmdline .= "-m " . convert_friendly_interface_to_real_interface_name($ladvd_conf['management']) . " ";
	}

	if($ladvd_conf['location'] != "") {
	    $cmdline .= "-l \"" . $ladvd_conf['location'] . "\" ";
	}

	if($ladvd_conf['lldp'] != "") {
	    $cmdline .= "-L ";
	}

	if($ladvd_conf['cdp'] != "") {
	    $cmdline .= "-C ";
	}

	if($ladvd_conf['edp'] != "") {
	    $cmdline .= "-E ";
	}

	if($ladvd_conf['fdp'] != "") {
	    $cmdline .= "-F ";
	}

	if($ladvd_conf['ndp'] != "") {
	    $cmdline .= "-N ";
	}

	$ifaces = explode(",", $ladvd_conf['iface_array']);
	$ifaces = array_map('convert_friendly_interface_to_real_interface_name', $ifaces);
	$cmdline .= implode(" ", $ifaces);

	write_rcfile(array(
		"file" => "ladvd.sh",
		"start" => "/usr/local/sbin/ladvd $cmdline",
		"stop" => "/usr/bin/killall -9 ladvd"
		)
	);

	exec("killall -9 ladvd");
	sleep(1);
	start_service("ladvd");
	sleep(1);
	conf_mount_ro();

}

?>
