#!/bin/sh
#
# Run me to update the file in the package repo.
#
OUI_URL=http://standards.ieee.org/develop/regauth/oui/oui.txt
OUI_FILE=/usr/local/share/nmap/nmap-mac-prefixes
#OUI_FILE=nmap-mac-prefixes
TEMP_FILE=/tmp/oui-prefixes.txt

# Prepare file
if [ -f ${TEMP_FILE} ]; then
	rm -f ${TEMP_FILE}
fi

echo "# Raw data obtained from ${OUI_URL}"  > ${TEMP_FILE}
echo "# Unregistered OUIs at the end are from NMAP - http://nmap.org/" >> ${TEMP_FILE}

/usr/bin/fetch -qo - ${OUI_URL} | /usr/bin/grep "base 16" | /usr/bin/sed -r 's/[[:blank:]]+/ /g' | /usr/bin/cut -c1-7,18- >> ${TEMP_FILE}

# Make sure it's valid
# Line count should be over 17,000
OUTPUT_WORD_COUNT=`/usr/bin/wc -l ${TEMP_FILE} | /usr/bin/awk '{print $1;}'`

# Spot check one line should contain  "589CFC.*FreeBSD"
OUTPUT_CHECK=`/usr/bin/grep -ci "589CFC.*FreeBSD" ${TEMP_FILE}`

if [ ${OUTPUT_WORD_COUNT} -gt 17000 ] && [ ${OUTPUT_CHECK} = 1 ]; then
	# Stuff in some missing prefixes
	echo "00FFD1 Cooperative Linux virtual NIC" >> ${TEMP_FILE}
	echo "2C7AFE IEE&E Black ops" >> ${TEMP_FILE}
	echo "525400 QEMU Virtual NIC" >> ${TEMP_FILE}
	echo "B0C420 Bochs Virtual NIC" >> ${TEMP_FILE}
	echo "DEADCA PearPC Virtual NIC" >> ${TEMP_FILE}
	echo "F0FB56 Apple" >> ${TEMP_FILE}
	if [ -f ${OUI_FILE} ]; then
		rm -f ${OUI_FILE}
	fi
	mkdir -p `/usr/bin/dirname ${OUI_FILE}`
	mv ${TEMP_FILE} ${OUI_FILE}
fi
