<?php
function parse_dhcpd_leases($path) {
	$keys = array("starts", "ends", "binding state", "client-hostname");

	$leases = array();
	$fd = fopen($path, "r");
	$entry = NULL;

	while(!feof($fd)) {
		# ignore empty lines and comments
		list($line, $ignored) = explode("#", $line, 1);
		$line = trim(fgets($fd));
		if (strlen($line) == 0) {
			continue;
		}

		if (1 == sscanf($line, "lease %s {", $ip)) {
			$leases[$ip] = array();
			$entry = &$leases[$ip];
			continue;
		}
		if ($line == "}") {
			unset($entry);
			continue;
		}
		foreach ($keys as $key) {
			if (1 == sscanf($line, $key . " %[^;];", $val)) {
				$entry[$key] = trim($val, '"');
				break;
			}
		}
	}
	return $leases;
}
