<?php

class watchpath {
	function __construct($path, $interval) {
		$this->path = $path;
		$this->interval = $interval;
		$this->last = time();
	}

	function wait() {
		while(true) {
			sleep($this->interval);

			clearstatcache();
			if (FALSE == ($stat = stat($this->path))) {
				continue;
			}

			$ctime = $stat[10];

			if ($ctime <= $this->last) {
				continue;
			}

			$this->last = $ctime;
			break;
		}
	}
}	

function printfile($path)
{
	$lines = file($path);
	echo("\n*** " . $path . "@" . $ctime . " ***\n");
	foreach ($lines as $num => $line) {
		echo($line);
	}
}


$path = "/tmp/test.txt";
$seconds = 1;

printfile($path);
$watchdog = new watchpath($path, $seconds);

while(true) {
	$watchdog->wait();
	printfile($path);
}
?>

