--- src/ifvc.c.orig
+++ src/ifvc.c
@@ -41,8 +41,10 @@
 **          
 */
 void buildIfVc() {
-    struct ifreq IfVc[ sizeof( IfDescVc ) / sizeof( IfDescVc[ 0 ] )  ];
+    struct ifreq IfVc[ MAX_IF * 2 ]; /* allocate in double in order to get as much information as possible */
     struct ifreq *IfEp;
+    struct IfDesc *dp;
+    struct SubnetList *allowednet, *currsubnet;
 
     int Sock;
 
@@ -82,9 +84,24 @@
 				    sizeof(struct sockaddr_in)
 #endif
 		    );
+
 	    if (IfNext < IfPt + 1)
 		    IfNext = IfPt + 1;
 
+            /* don't retrieve any further info if MAX_IF is reached
+             */
+            if ( IfDescEp >= &IfDescVc[ MAX_IF ] ) {
+                my_log(LOG_DEBUG, 0, "Too many interfaces, skipping all since %s", IfPt->ifr_name);
+                break;
+            }
+
+            /* don't retrieve any info from non-IPv4 interfaces
+             */
+            if ( IfPt->ifr_addr.sa_family != AF_INET ) {
+                my_log(LOG_DEBUG, 0, "Interface is not AF_INET, skipping %s (family %d)", IfPt->ifr_name, IfPt->ifr_addr.sa_family);
+                continue;
+            }
+
             strncpy( IfDescEp->Name, IfPt->ifr_name, sizeof( IfDescEp->Name ) );
 
             // Currently don't set any allowed nets...
@@ -93,14 +110,6 @@
             // Set the index to -1 by default.
             IfDescEp->index = -1;
 
-            /* don't retrieve more info for non-IP interfaces
-             */
-            if ( IfPt->ifr_addr.sa_family != AF_INET ) {
-                IfDescEp->InAdr.s_addr = 0;  /* mark as non-IP interface */
-                IfDescEp++;
-                continue;
-            }
-
             // Get the interface adress...
             IfDescEp->InAdr = ((struct sockaddr_in *)&IfPt->ifr_addr)->sin_addr;
             addr = IfDescEp->InAdr.s_addr;
@@ -115,6 +124,20 @@
             mask = ((struct sockaddr_in *)&IfReq.ifr_addr)->sin_addr.s_addr;
             subnet = addr & mask;
 
+            dp = getIfByName(IfPt->ifr_name, 1);
+            if (dp != NULL && dp->allowednets != NULL) {
+                allowednet = (struct SubnetList *)malloc(sizeof(struct SubnetList));
+                if (allowednet == NULL) my_log(LOG_ERR, 0, "Out of memory !");
+                allowednet->next = NULL;
+                allowednet->subnet_mask = mask;
+                allowednet->subnet_addr = subnet;
+                currsubnet = dp->allowednets;
+                while (currsubnet->next != NULL)
+                    currsubnet = currsubnet->next;
+                currsubnet->next = allowednet;
+                continue;
+            }
+
             /* get if flags
             **
             ** typical flags:
@@ -166,12 +189,15 @@
 **          - NULL if no interface 'IfName' exists
 **          
 */
-struct IfDesc *getIfByName( const char *IfName ) {
+struct IfDesc *getIfByName( const char *IfName, int iponly ) {
     struct IfDesc *Dp;
 
-    for ( Dp = IfDescVc; Dp < IfDescEp; Dp++ )
+    for ( Dp = IfDescVc; Dp < IfDescEp; Dp++ ) {
+        if (iponly && Dp->InAdr.s_addr == 0)
+            continue;
         if ( ! strcmp( IfName, Dp->Name ) )
             return Dp;
+    }
 
     return NULL;
 }
