#!/bin/sh

estabcount=0
p2count=0
totalcount=0
buferr=0

bounceall() {
        echo "Restarting"
        echo "Restarting" | logger
        /usr/local/etc/rc.d/bgpd.sh stop
        sleep 1
        $ipsecpath stop
        sleep 1
        $ipsecpath start
        sleep 3
        /usr/local/etc/rc.d/bgpd.sh start
}

ipsecpath=/usr/local/sbin/ipsec

echo "=== ipsecmon started at `date` ==="
echo "=== ipsecmon started at `date` ===" | logger

for con in `$ipsecpath status | grep "\[" | sed 's/\[.*//g' | sort | uniq` ;
do 
        echo $con
        estab=0
        p2=0

        $ipsecpath status $con | grep ESTAB >/dev/null 2>&1 && estab=1
        $ipsecpath status $con | grep INSTALLED >/dev/null 2>&1 && p2=1

        [ $estab -eq 1 ] && { 
                echo $con p1 up
#               echo $con p1 up | logger   ## This is too chatty
                estabcount=$(( $estabcount + 1 ))
                
                [ $p2 -eq 0 ] && {
                        echo $con p2 down, restarting
                        echo $con p2 down, restarting | logger
                        echo stopping $con...
                        echo stopping $con... | logger
                        $ipsecpath down $con >/dev/null 2>&1
                        sleep 1
                        echo starting $con...
                        echo starting $con... | logger
                        $ipsecpath up $con | grep error | grep "buffer space" >/dev/null 2>&1  && { echo "PF_KEY buffer error while starting $con"; buferr=$(( $buferr + 1 )); }
                }

        }

        [ $estab -eq 0 ] && { 
                echo $con p1 down
                echo $con p1 down | logger
        }
        [ $p2 -eq 1 ] && {
                echo $con p2 up
#               echo $con p2 up | logger ## This is too chatty
                p2count=$(( $p2count + 1 ));
        }
        totalcount=$(( $totalcount + 1 ))
done

echo
echo ===
echo estab $estabcount / $totalcount
echo estab $estabcount / $totalcount | logger
echo p2 $p2count / $totalcount
echo p2 $p2count / $totalcount | logger
echo buf_err $buferr / $totalcount
echo buf_err $buferr / $totalcount | logger
echo === ipsecmon ended ===
echo === ipsecmon ended === | logger
echo

[ $totalcount -gt 0 ] && [ $buferr -gt 0 ] && {
        echo $buferr connections show buffer space errors - bouncing openbgpd and ipsec
        echo $buferr connections show buffer space errors - bouncing openbgpd and ipsec | logger
        bounceall
        exit
}

[ $totalcount -gt 0 ] && [ $estabcount -eq 0 ] && {
        echo no connections have p1 up - bouncing openbgpd and ipsec
        echo no connections have p1 up - bouncing openbgpd and ipsec | logger
        bounceall
        exit
}

[ $totalcount -gt 0 ] && [ $estabcount -eq $totalcount ] && [ $p2count -eq 0 ] && {
        echo all connections have p1 up but no connections have p2 up - bouncing openbgpd and ipsec
        echo all connections have p1 up but no connections have p2 up - bouncing openbgpd and ipsec | logger
        bounceall
        exit
}
