#!/bin/sh
#
# Kneel to zod. :-(
#
# The unit powers on in NMEA mode at 4800bps. Ensure our rate is matched.
# If the Jupiter unit has been cold started, it may be necessary to
# reset its RTC contents to get correct time output.
# If NTPD itself has reconfigured the receiver, all bets are off;
# you will either need to reconfigure it manually, or wait for
# a full GPS cold start?
#
zoddev=/dev/cuau0

_zod_1330_set_port1_9600='\x32\x05\x00\x00\x01\x00\x01\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xff'

# Get-out clause:
#_zod_revert_nmea='\x33\x05\x00\x00\x00\x00\x01\x00\xff\xff'
#gpsctl -f -t Zodiac -x $_zod_revert_nmea ${PORT}

stty < ${zoddev}.init speed 4800
stty < ${zoddev}.lock speed 4800

# Perform a full bootstrap. Reset the UTC time to what we have.
# This requires exact arguments (and UTC time) -- see strftime(3).
# This will also reset the unit to 4800bps if it was in another mode.
# NOTE: This should probably be done after 'ntpdate' against
# a trusted reliable source.
ntpdate -bvu 192.168.1.250
_zod_time=$(date -u '+%H%M%S')
_zod_date=$(date -u '+%d%m%g')
printf > ${zoddev} '$PRWIINIT,A,,,,,,,,,,,,%s,%s\r\n' $_zod_time $_zod_date

## Perform only a soft set of the date and time
#printf > ${zoddev} '$PRWIINIT,V,,,,,,,,,,,,%s,%s\r\n' $_zod_time $_zod_date

# Put the unit into ZODIAC binary mode at 4800bps.
printf > ${zoddev} '$PRWIIPRO,,RBIN\r\n'

# Take the unit into 9600bps in binary mode.
# I'm not convinced that gpsctl does this correctly automatically,
# so send it a raw ZODIAC packet, trusting it to compute the header OK.
gpsctl -f -t Zodiac -x $_zod_1330_set_port1_9600 ${zoddev}

# Finally, leave rate set to 9600 for ntpd.
stty < ${zoddev}.init speed 9600
stty < ${zoddev}.lock speed 9600
