#!/bin/sh
#
# Initialization script. Good for me. Maybe you too.  - bms
#
_ubloxdev=/dev/cuaU0
_gpsctl=gpsctl
_gpsctl_opts="-f -t u-blox"

### Binary mode config.

# On USB, accept UBX and NMEA; emit only UBX.
${_gpsctl} ${_gpsctl_opts} -x '\x06\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x01\x00\x00\x00\x00\x00' ${_ubloxdev}

# Enable all UBX messages.
${_gpsctl} ${_gpsctl_opts} -x '\x06\x02\x00\x00\x00\x00\x00\x00\x00\x1F' ${_ubloxdev}

# Disable all NMEA messages.
${_gpsctl} ${_gpsctl_opts} -x '\x06\x02\x01\x00\x00\x00\x00\x00\x00\x00' ${_ubloxdev}

### 1PPS config.

# Enable 1PPS on +-ve assert, UTC seconds, no antenna/group/user delay factor,
# UTC seconds only, 100us pulse length.
# (1PPS is NOT supported on USB without using a separate GPIO line.)
${_gpsctl} ${_gpsctl_opts} -x '\x06\x07\xE8\x03\x00\x00\x54\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' ${_ubloxdev}

### Performance tuning.

# Enable max performance mode.
${_gpsctl} ${_gpsctl_opts} -x '\x06\x11\x00\x00' ${_ubloxdev}

# Enable auto 2D/3D fix mode, with 3 sats minimum, 20 sats maximum.
${_gpsctl} ${_gpsctl_opts} -x '\x06\x23\x00\x00\x44\x00\x00\x00\x00\x00\x00\x00\x03\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' ${_ubloxdev}

### Localisation for SBAS extra satellite feeds.

# Astra-5B only (London, UK -- limited sky view.)
${_gpsctl} ${_gpsctl_opts} -x '\x06\x16\x03\x07\x01\x00\x08\x00\x00\x00' ${_ubloxdev}

# Now ready to run gpsd on ${_ubloxdev} itself.
exit 0
