--- dhcp6c.c.orig	2017-01-25 07:09:23 UTC
+++ dhcp6c.c
@@ -1751,23 +1751,23 @@ client6_recvreply(ifp, dh6, len, optinfo
 
 	switch (state) {
 	case DHCP6S_INFOREQ:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received INFOREQ");
-		break;  
-	case DHCP6S_REQUEST:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received REQUEST");
-		break;
-	case DHCP6S_RENEW:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received INFO");
-		break;
-	case DHCP6S_REBIND:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received REBIND");
-		break;
-	case DHCP6S_RELEASE:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received RELEASE");
-		break;
-	case DHCP6S_SOLICIT:
-		d_printf(LOG_INFO, FNAME, "dhcp6c Received SOLICIT");
-		break;          
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Info Reply");
+ 		break;  
+ 	case DHCP6S_REQUEST:
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Reply");
+ 		break;
+ 	case DHCP6S_RENEW:
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Renew");
+ 		break;
+ 	case DHCP6S_REBIND:
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Rebind");
+ 		break;
+ 	case DHCP6S_RELEASE:
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Release");
+ 		break;
+ 	case DHCP6S_SOLICIT:
+		d_printf(LOG_INFO, FNAME, "dhcp6c Received Solicit");
+ 		break;             
 	}
 
 	/* A Reply message must contain a Server ID option */
@@ -1932,9 +1932,12 @@ client6_recvreply(ifp, dh6, len, optinfo
 	 * configuration parameters.
 	 */
 	if (ifp->scriptpath != NULL && strlen(ifp->scriptpath) != 0) {
-		d_printf(LOG_DEBUG, FNAME, "executes %s", ifp->scriptpath);
-		client6_script(ifp->scriptpath, state, optinfo);
-	}
+	/* Do not call script if the no_scrip option is set and this is the response to a request. Let RTSOLD call the script */
+ 		d_printf(LOG_DEBUG, FNAME, "executes %s", ifp->scriptpath);
+ 		client6_script(ifp->scriptpath, state, optinfo);
+	} else {
+	  d_printf(LOG_DEBUG, FNAME, "Option no-script active, Script execution bypassed", ifp->scriptpath);
+ 	}
 
 	dhcp6_remove_event(ev);
 
