--- dhcp6c_script.c.orig	2016-12-19 08:16:42 UTC
+++ dhcp6c_script.c
@@ -167,10 +167,35 @@ client6_script(scriptpath, state, optinf
 	 */
 	i = 0;
 	/* reason */
+	
+	switch (state) {
+	case DHCP6S_INFOREQ:
+		sprintf(reason,"REASON=INF");
+ 		break;  
+ 	case DHCP6S_REQUEST:
+		sprintf(reason,"REASON=REP");
+ 		break;
+ 	case DHCP6S_RENEW:
+		sprintf(reason,"REASON=REN");
+ 		break;
+ 	case DHCP6S_REBIND:
+		sprintf(reason,"REASON=REB");
+ 		break;
+ 	case DHCP6S_RELEASE:
+		sprintf(reason,"REASON=REL");
+ 		break;
+ 	case DHCP6S_SOLICIT:
+		sprintf(reason,"REASON=OFR");
+ 		break;             
+	default:
+	      sprintf(reason,"REASON=NBI");
+	}
+	
+	
 	if ((envp[i++] = strdup(reason)) == NULL) {
 		d_printf(LOG_NOTICE, FNAME,
 		    "failed to allocate reason strings");
-		ret = -1;
+		ret = -1; 
 		goto clean;
 	}
 	/* "var=addr1 addr2 ... addrN" + null char for termination */
